
//***************************************************************************
//*                                                                         *
//*  Functions to ask for the game SETTINGS                                 *
//*                                                                         *
//***************************************************************************

function number_of_copies_changed(new_value)
{
    act_copies = parseInt(new_value);
    ask_for_game_settings();
}

function number_of_players_changed(new_value)
{
    act_players = parseInt(new_value);
    ask_for_game_settings();
}

function number_of_used_images_changed(new_value)
{
    used_images = parseInt(new_value);
    ask_for_game_settings();
}

function number_of_matching_images_changed(new_value)
{
    num_matching_images = parseInt(new_value);
    set_matching_images = num_matching_images;
    ask_for_game_settings();
}

function image_width_changed(new_value)
{
    image_width = parseInt(new_value);
    ask_for_game_settings();
}

//-----------------------   ask_for_game_settings ()   ---------------------------
// Draw HTML page using JavaScript. This offers maximum control over the HTML
// output.
function ask_for_game_settings()
{

     // increase counter of drawings of this page
     settings_page_counter++;

     // Write the headlines
    write_html_head_lines("Memoryspiel: Einstellungen");

    // text-line: settings for game
    of.document.write ("<br><u><b><font size=\"+1\">Einstellungen fr das Spiel</font></b></u>");

    // begin form
    of.document.write ("<form name=\"form_GameSettings\">\n");

    // select number of players
    of.document.write ("<select name=\"select_NumberOfPlayers\" size=\"1\" onChange=\"top.number_of_players_changed(document.form_GameSettings.select_NumberOfPlayers.value);\"> \n");
    for (i=1; i <= max_players; i++)
    {   // push() is not supported by this object.
        // following method caused error with IE 5.0    if this is reactivated move </select> above        //of.document.form_GameSettings.select_NumberOfPlayers.options[
        //  of.document.form_GameSettings.select_NumberOfPlayers.options.length] = new Option (i, i);
        of.document.write ('<option value="' + i + '">' + i + '</option>\n');
    }
    // next would be nice for equal width of all selection box fields. But "disabled" does not work.
    // of.document.write ('<option disabled> Listenende </option>\n');
    of.document.write ("</select>\n");
    of.document.form_GameSettings.select_NumberOfPlayers.selectedIndex = act_players - 1;
    of.document.write ("Wieviele Spieler spielen mit? <br>\n");

    // select number of copies to be made of each image
    of.document.write ("<select name=\"select_NumberOfCopies\" size=\"1\"\n onChange=\"top.number_of_copies_changed(document.form_GameSettings.select_NumberOfCopies.value);\">\n");
    var min_copies = 1;
    if (max_matching_images >= 2)
    {
        min_copies = 0;
        if (settings_page_counter == 1)   // change only if it is the first settings dialog
        {
            act_copies = 0;
        }
    }

    for (i = min_copies; i < max_copies; i++)
    {
        of.document.write ('<option value="' + i + '">' + i + '</option>\n');
    }
    of.document.write ("</select>\n");
    of.document.form_GameSettings.select_NumberOfCopies.selectedIndex = act_copies - min_copies;
    of.document.write ("Wieviele Kopien sollen von jedem Bild angefertigt werden? <br>\n");

    // select: If no copy: how much pictures belong together
    if (act_copies == 0)
    {
        num_matching_images = set_matching_images;    // could be changed if act_copies was > 0
        of.document.write ("<select name=\"select_matchingImages\" size=\"1\" onChange=\"top.number_of_matching_images_changed(document.form_GameSettings.select_matchingImages.value);\"> \n");
        for (i=2; i <= max_matching_images; i++)        // i = 1 makes no sense!
        {
            of.document.write ('<option value="' + i + '">' + i + '</option>\n');
        }
        of.document.write ("</select>\n");
        of.document.form_GameSettings.select_matchingImages.selectedIndex = num_matching_images - 2;
        of.document.write ("Wieviele der definierten Bilder geh&ouml;ren jeweils zusammen? <br>\n");
    }
    else
    {
        num_matching_images = act_copies + 1;
    }


    // select number of different images to be used
    of.document.write ("<select name=\"select_NumberOfUsedImages\" size=\"1\" onChange=\"top.number_of_used_images_changed(document.form_GameSettings.select_NumberOfUsedImages.value);\">\n");
    var step      = (act_copies == 0)? num_matching_images : 1;
    var sel_index = (act_copies == 0)? (used_images / num_matching_images) - 1 : used_images - 1
    for (i=step; i <= number_of_predefined_images; i+=step)
    {
        of.document.write ('<option value="' + i + '">' + i + '</option>\n');
    }
    of.document.write ("</select>\n");
    of.document.form_GameSettings.select_NumberOfUsedImages.selectedIndex = sel_index;
    of.document.write ("Wieviele der " + number_of_predefined_images + " definierten Bilder sollen verwendet werden? <br>\n");


    // select image width
    // var window_width = window.innerWidth;     only for Netscape
    step = 25;
    of.document.write ("<select name=\"select_ImageWidth\" size=\"1\" onChange=\"top.image_width_changed(document.form_GameSettings.select_ImageWidth.value);\"> \n");
    //of.document.write (" (Fensterbreite = " + window_width + \n")\n");
    for (i=step; i <= 250; i+=step)
    {
        of.document.write ('<option value="' + i + '">' + i + '</option>\n');
    }
    of.document.write ("</select>\n");
    of.document.form_GameSettings.select_ImageWidth.selectedIndex = (image_width / step) - 1;
    of.document.write ("Wieviele Punkte breit sollen die Bilder ausgegeben werden? <br>\n");

    // Output of number of Memory pieces
    number_of_images = (act_copies + 1) * used_images;
    of.document.write ("Mit den aktuellen Einstellungen werden " + number_of_images + " Memoryteile gemalt<br>\n");

    // Buttons to start game, show images and for user manual
    of.document.write ('<input type="button" name="button_StartGame" value="Starte das Memoryspiel" onClick="top.start_game();"><br>\n');
    of.document.write ('<input type="button" name="button_ShowImages" value="Zeige alle definierten Bilder" onClick="top.show_images();"><br>\n');
    of.document.write ('<input type="button" name="button_OpenUserManual" value="Anleitung frs Spiel und fr den Einbau eigener Bilder" onClick="new_wnd=top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();">\n');

    // End of form
    of.document.write ("</form>\n");

 }  // end: function ask_for_game_settings()