//-----------------------   start_game ()   ---------------------------
// This function is called to start a new game by the settings page start button
//
function start_game()
{
    init_new_game();
    mix_images();
}

//-----------------------   stop_game ()   ---------------------------
// Draw HTML page, mix images, hide images, ...
//
function stop_game()
{
    if (confirm("Willst du das Spiel abbrechen und ein neues starten?"))
    {
        ask_for_game_settings();
    }
}   // end: function stop_game()



//-----------------------   init_new_game ()   ---------------------------
// Draw HTML page, mix images, hide images, ...
//
function init_new_game()
{
    // generate array for all images and copies and mix it
    generate_mixed_image_array();

    // initialize some variables before starting the game
    init_variables_before_new_game();

    // Draw HTML output
    draw_html_for_game();

    // fill output fields with actual values
    output_actual_game_standings();

 }  // end: function init_new_game()



//-----------------------   init_variables_before_new_game ()   ----------------
// initialize some variables before starting the game
//
function init_variables_before_new_game()
{
    act_player    = 1;
    round_counter = 1;
    opened_images_in_turn = 0;
    last_clicked_indexes.length = 0;   // empty array
    for (i = 0;   i < num_matching_images;   i++)
    {
        last_clicked_indexes[last_clicked_indexes.length] = -1;
    }

    points_of_player.length = 0;
    for (i = 0;   i < act_players;   i++)
    {
        points_of_player[points_of_player.length] = 0;
    }

 }  // end: function init_variables_before_new_game()



//-----------------------   output_actual_game_standings ()   ------------------
// Write actual round, standings etc. to the html elements.
//
function output_actual_game_standings()
{
    //of.document.form_Game.input_act_player.value = act_player;
    of.document.form_Game.input_rounds.BgColor = "red";     // no effect
    of.document.form_Game.input_rounds.Color = "red";       // no effect
    of.document.form_Game.input_rounds.value = round_counter;

    for (i = 1; i <= act_players; i++)
    {
        var element_name = "input_player" + i;
        var input_elements = of.document.getElementsByName(element_name);

        if (input_elements)
        {
            if (i == act_player)
            {
                input_elements[0].size = 30;
                if (opened_images_in_turn < num_matching_images)
                {
                    input_elements[0].value = (opened_images_in_turn + 1) +
                         ". Bild aufdecken!      " + points_of_player[i - 1];
                }
                else
                {
                    input_elements[0].value =
                         "Aufgedeckte Bilder zudecken.   " + points_of_player[i - 1];
                }
                input_elements[0].focus();
                input_elements[0].select();
            }
            else
            {
                input_elements[0].size = 3;
                input_elements[0].value = points_of_player[i - 1];
            }
        }
    }

}  // end: function output_actual_game_standings()



//-----------------------   generate_mixed_image_array ()   --------------------
// generate array for all images and copies and mix it
// This function depends an act_copies==0 or not. Afterwards we become
// independent from this setting. Therefore this function is a little bit
// complicated.
//
function generate_mixed_image_array()
{
    // make a copy of the original names and mix it in order to use the first
    // used_images pictures as input for the big array.
    // In case of act_copies==0 we must only use a part of the indexes!
    var step = (act_copies > 0) ?  1 : num_matching_images;   // step width for image selection
    var help_array   = new Array ();
    var random_array = new Array (number_of_predefined_images);
    random_array.length   = 0;   // empty array to be sure
    help_array.length     = 0;   // empty array to be sure

    for (i=0; i < (number_of_predefined_images - step + 1); i += step)
    {
        random_array[random_array.length]=Math.random();
        help_array[help_array.length]=i;
    }

    mix_array (random_array, help_array);

    // Empty and refill the final arrays with data and then mix them
    mixed_images.length   = 0;    // empty array. this works!
    indexes_array.length  = 0;
    random_array.length   = 0;
    index = 0;
    for (i = 0;   i < (used_images / step);   i++)
    {
        for (j = 0;   j <= act_copies;   j++)    // for act_copies  > 0
        {
            for (k = 0;   k < step;   k++)       // for act_copies == 0
            {
                mixed_images[mixed_images.length] = predefined_image_names[help_array[i] + k];
                indexes_array[indexes_array.length] = index++;
                random_array[random_array.length] = Math.random();
            }
        }
    }

    mix_array (random_array, indexes_array);

}   // end: generate_mixed_image_array()



//-----------------------   draw_html_for_game ()   ---------------------------
// Draw HTML page including dummy images
//
function draw_html_for_game()
{
    // Write the headlines
    write_html_head_lines("Memoryspiel: Das Spiel luft");

     // begin form
    of.document.write ("<form name=\"form_Game\">\n");

    // Roundcounter
    of.document.write ("<font size=\"+1\"5>Runde </font> <input type=\"text\" name=\"input_rounds\" size=\"3\" disabled></input> \n");

    // Buttons to stop game and for user manual
    of.document.write ("<input type=\"button\" name=\"button_StopGame\" value=\"Beende das Memoryspiel\" onClick=\"top.stop_game();\">\n");
    of.document.write ('<input type="button" name="button_OpenUserManual" value="Anleitung frs Spiel" onClick="new_wnd=top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();"><br>\n');

    // Actual standings
    for (i = 1; i <= act_players; i++)
    {
        of.document.write ("<font size=\"+1\">Spieler " + i + ": </font><input type=\"text\" name=\"input_player" + i + "\" size=\"3\" readonly></input> \n");
    }

    // active player
    // of.document.write ("<br><font size=5 color=\"red\">Wer ist dran? Spieler Nr.<input type=\"text\" name=\"input_act_player\" size=\"2\" disabled></input> \n </font>");

    // End of form
    of.document.write ("</form>\n");

    // Draw dummy images
    var alt_text;                              // fly-over text
    for (i = 0; i < number_of_images; i++)
    {
         // ! the name is used to extract the picture index. Do not change the name syntax!
         alt_text = "Memoryteil_" + (i+1);
         if (show_picture_name == true)
         {
             alt_text += ":_";     // with blank here, IE6.0 cuts output at blank
             alt_text += mixed_images[indexes_array[i]];
         }
         of.document.write ('<img src="' + hidden_picture_name + '" width="' + image_width + '" border="0" alt="' + alt_text + '" name="image' + i + '" onClick="top.show_hidden_image(this)">');
    }

}  // end: function draw_html_for_game()


//-----------------------   show_hidden_image ()   -----------------------------
// parameter: this-object of the clicked image. We use it to determine the
// index of the image that was clicked by comparing clicked_image with all
// other images actually displayed.
function show_hidden_image (clicked_image)
{
    if (opened_images_in_turn < num_matching_images)
    {
        // This is a real click (else: just click to jump to next player

        // replace the dummy picture by the Memory image
        var clicked_index = -1;     // index of image that was clicked
        clicked_index = parseInt(clicked_image.name.substr(5,10));
        if (clicked_image.src.search(hidden_picture_name) != -1)
        {
            // only in this case we have to do anything. Else the image is not
            // hidden and the click is ignored
            displayed_picture_index = indexes_array[clicked_index];
            of.document.images[clicked_index].src = mixed_images[displayed_picture_index];

            // store clicked index
            last_clicked_indexes[opened_images_in_turn] = clicked_index;
            opened_images_in_turn++;

            if (opened_images_in_turn == num_matching_images)
            {
                // The player has opened the maximum number of images. Now check
                // whether they match.
                matching = true;
                for (i = 0;   i < (num_matching_images - 1);   i++)
                {
                    if (Math.floor(indexes_array[last_clicked_indexes[i]  ] / num_matching_images)
                    !=  Math.floor(indexes_array[last_clicked_indexes[i+1]] / num_matching_images))
                    {
                        matching = false;
                    }
                }

                if (matching == true)
                {
                    // the actual player gets a point, remains on turn and the
                    // images are replaced by the "found picture".
                    points_of_player[act_player - 1]++;
					if (found_action == 0)
					{
						for (i = 0;   i < num_matching_images;   i++)
						{
							of.document.images[last_clicked_indexes[i]].src = found_picture_name;
							last_clicked_indexes[i] = -1;
						}
						opened_images_in_turn = 0;
					} else if (found_action == -1)
					{
						for (i = 0;   i < num_matching_images;   i++)
						{
							of.document.images[last_clicked_indexes[i]].border = 3;
							of.document.images[last_clicked_indexes[i]].width = image_width - 6;
							// last_clicked_indexes[i] = -1;    This will be done after next click (But not, if game is finished, but this does not matter)
						}
						// opened_images_in_turn = 0;     This will be done after next click (But not, if game is finished, but this does not matter)
					} else if (found_action == -2)
					{
                        alert ("Richtige Kombination gefunden! \n Nach OK geht das Spiel weiter.");
						
						for (i = 0;   i < num_matching_images;   i++)
						{
							of.document.images[last_clicked_indexes[i]].src = found_picture_name;
							last_clicked_indexes[i] = -1;
						}
						opened_images_in_turn = 0;
					} else if (found_action > 0)
					{
                        alert ("!!! Diese Funktion (Anzeige des gefundenen Paars fr einige Sekundenden) ist noch nicht implementiert.  !!!\n Eigentlich sollte das Programm gar nicht hierher kommen.");
					} else
					{
                        alert ("Ungltiger Wert von found_action: " + found_action + "\n Das sollte nicht passieren.");
					}
						

                    // test whether all pieces are found
                    var found_images = 0;
                    for (i = 0;   i < act_players;   i++)
                    {
                        found_images += points_of_player[i];
                    }
                    found_images *= num_matching_images;
                    if (found_images == number_of_images)
                    {
                        output_actual_game_standings();   // show standings before msg box
                        if (act_players == 1)
                        {
                            alert ("!!! Herzlichen Glckwunsch !!!\n Du hast alles richtig gefunden. \n Drcke OK um ein neues Spiel zu starten.");
                        }
                        else
                        {
                            alert ("!!! Herzlichen Glckwunsch !!!\n Ihr habt alles richtig gefunden. \n Drckt OK um ein neues Spiel zu starten.");
                        }
                        ask_for_game_settings();
                        return;
                    }

                }
                else
                {
                    // images not matching: just wait for next click on image before
                    // hiding the opened images and jumping to next player
                }
            }
        }
    }   // end: if (opened_images_in_turn < num_matching_images)
    else
    {
        // This was a click to jump to next player
		
		if (matching)
		{
			// images matching: show empty images and jump to next player
			for (i = 0;   i < num_matching_images;   i++)
			{
				of.document.images[last_clicked_indexes[i]].src = found_picture_name;
				of.document.images[last_clicked_indexes[i]].border = 0;
				of.document.images[last_clicked_indexes[i]].width = image_width;
				last_clicked_indexes[i] = -1;    // This will be done after next click
			}
		}

		else 
		{
			// images not matching: hide the opened images and jump to next player
			for (i = 0;   i < num_matching_images;   i++)
			{
				of.document.images[last_clicked_indexes[i]].src = hidden_picture_name;
				last_clicked_indexes[i] = -1;
			}
		}

        // jump to next player
        opened_images_in_turn = 0;
        if (act_player == act_players)
        {
            act_player = 1;
            round_counter++;
        }
        else
        {
            act_player++;
        }
    }

    output_actual_game_standings();

    return;

}

//-----------------------   mix_images ()   ------------------------------------
// Use random generator to mix the order of the images
function mix_images()
{
    random_array = new Array(number_of_images);
    index_array  = new Array(number_of_images);
    for (i=0; i < number_of_images; i++)
    {
        random_array[i] = Math.random();
        index_array[i]  = i;
        // alert (random_array[i] + ", " + index_array[i]);
    }

    mix_array (random_array, index_array);

    // Draw mixed images  (only for testing)
    for (i=0; i < number_of_images; i++)
    {
           //alert (random_array[i] + ", " + index_array[i]);
    //     document.images[i].src = original_images[index_array[i]];
    }
}   // end: function mix_images()