//-----------------------   start_game ()   ---------------------------
// This function is called to start a new game by the settings page start button
//
function start_game()
{
    init_new_game();
    mix_images();
}

//-----------------------   stop_game ()   ---------------------------
// Draw HTML page, mix images, hide images, ...
//
function stop_game()
{
    if (confirm("Willst du das Spiel abbrechen und ein neues starten?"))
    {
        ask_for_game_settings();
    }
}   // end: function stop_game()



//-----------------------   init_new_game ()   ---------------------------
// Draw HTML page, mix images, hide images, ...
//
function init_new_game()
{
	// generate math-problems
	generate_math_problems();
	
	if (number_of_images < 2)
	{
		alert ("   !!!   ACHTUNG   !!! \nEs konnten keine Aufgaben erstellt werden. \nDeshalb wird das Spiel nicht gestartet. \nBitte prfe die Einstellungen. \n");
		return;
	}
	
    // generate array for all images and copies and mix it
    generate_mixed_image_array();

    // initialize some variables before starting the game
    init_variables_before_new_game();

    // Draw HTML output
    draw_html_for_game();
	
    // fill output fields with actual values
    output_actual_game_standings();
	
	// Scroll window to see what is needed to play. 
	// All trials with achors within or outside of the form did not work.
	// Therefore I added a copy of the buttons at the bottom, focus first
	// to them and then set focus to the buttons at the top. As this 
	// scrolled to the very top, I commented it out ...
	//window.location.hash = "ancho";    //OK
	//window.location.hash = "#ancho";   //OK
	//window.location.hash = "#anchos";   //OK
	//window.location = "ancho";         //crash
	//window.location = "#ancho";
	// of.submit();   // Exception
	
	// focussing to a <a href="..." id="focus_point_href"> works
	var element = of.document.getElementById("focus_point_href");
	element.focus();
	
	// focussing to an anchor without href did not work: 
	// The element was found, but focus() had no effect.
	// var elements = of.document.getElementsByName("focus_point_anchor");
	// elements[0].focus();
	
	// window.scrollTo(0, 1300);  did not work, may be due to the form
	// window.scrollBy(0, 300);   did not work, may be due to the form
	// of.document.getElementsByName("button_StopGame3" )[0].focus();   // This worked with <input button>, but those buttons look ugly

 }  // end: function init_new_game()



//-----------------------   init_variables_before_new_game ()   ----------------
// initialize some variables before starting the game
//
function init_variables_before_new_game()
{
    act_player    = 1;
    round_counter = 1;
    opened_images_in_turn = 0;
	timeouts_started  = 0;    
	timeouts_finished = 0;  
	start_of_game = new Date();
    last_clicked_indexes.length = 0;   // empty array
    for (i = 0;   i < num_matching_images;   i++)
    {
        last_clicked_indexes[last_clicked_indexes.length] = -1;
    }

    points_of_player.length = 0;
    for (i = 0;   i < act_players;   i++)
    {
        points_of_player[points_of_player.length] = 0;
    }

 }  // end: function init_variables_before_new_game()



//-----------------------   output_actual_game_standings ()   ------------------
// Write actual round, standings etc. to the html elements.
//
function output_actual_game_standings()
{
	var i;
	
	replace_sub_images_of_number (round_counter, images_in_front_of_round_counter);
	
    for (i = 1; i <= act_players; i++)
    {
		help = points_of_player[i - 1].toString();
		replace_sub_images_of_number (points_of_player[i - 1], images_in_front_of_pt_counter_1 + ((i-1) * digits_points_counter));
    }
	
	// next action
	if (opened_images_in_turn < num_matching_images)
	{		
		help = "Nchste Aktion: Spieler " + act_player + " deckt das " + (opened_images_in_turn + 1) + ". Bild mit einem Mausklick auf"
	}
	else
	{		
		help = "Nchste Aktion: Spieler " + act_player + " deckt alle offenen Bilder mit einem Mausklick zu"
	}
	var textnode = of.document.getElementById("next_act");   // NOTE: do not use document, but of.document!!
	help = "Zeit: "  + ((new Date().getTime() - start_of_game.getTime()) / 1000) + " Sekunden.   " + help;
	while (help.length < 100) help += ".";
	textnode.textContent = help;
	//of.document.form_Game.button_NextAction.value = help;	    // old method with output to ugly button
	//of.document.form_Game.button_TimeUsage.value = "Verbrauchte Zeit seit dem Start des Spiels: " 
	//				+ ((new Date().getTime() - start_of_game.getTime()) / 1000) + " Sekunden";

}  // end: function output_actual_game_standings()

//---------------------   replace_sub_images_of_number   ----------------------
// Writes the input number left adjusted using the single digit images 5.png etc.
// starting at of.document.images[start_index]
function replace_sub_images_of_number (number, start_index)
{
	var i;
	var help = number.toString();
	for (i = 0;   i < help.length;   i++)
	{
		of.document.images[i + start_index].src = help[i] + "_transp.png";
	}
	return;
}

//-----------------------   generate_mixed_image_array ()   --------------------
// generate array for all images and copies and mix it
// This function depends an act_copies==0 or not. Afterwards we become
// independent from this setting. Therefore this function is a little bit
// complicated.
//
function generate_mixed_image_array()
{
    // make a copy of the original names and mix it in order to use the first
    // used_images pictures as input for the big array.
    // In case of act_copies==0 we must only use a part of the indexes!
    var step = (act_copies > 0) ?  1 : num_matching_images;   // step width for image selection
    var help_array   = new Array ();
    var random_array = new Array (number_of_predefined_images);
    random_array.length   = 0;   // empty array to be sure
    help_array.length     = 0;   // empty array to be sure

    for (i=0; i < (number_of_predefined_images - step + 1); i += step)
    {
        random_array[random_array.length]=Math.random();
        help_array[help_array.length]=i;
    }

    mix_array (random_array, help_array);

    // Empty and refill the final arrays with data and then mix them
    mixed_images.length   = 0;    // empty array. this works!
    indexes_array.length  = 0;
    random_array.length   = 0;
    index = 0;
    for (i = 0;   i < (used_images / step);   i++)
    {
        for (j = 0;   j <= act_copies;   j++)    // for act_copies  > 0
        {
            for (k = 0;   k < step;   k++)       // for act_copies == 0
            {
                mixed_images[mixed_images.length] = predefined_image_names[help_array[i] + k];
                indexes_array[indexes_array.length] = index++;
                random_array[random_array.length] = Math.random();
            }
        }
    }

    mix_array (random_array, indexes_array);

}   // end: generate_mixed_image_array()



//-----------------------   draw_html_for_game ()   ---------------------------
// Draw HTML page including dummy images
//
function draw_html_for_game()
{
	var help = "";
	var i = 0;
	var j = 0;
	
    // Write the headlines
    write_html_head_lines("Memoryspiel: Das Spiel luft");

     // begin form
	of.document.write ("<a name=\"ancho\"></a> \n");
    of.document.write ("<form name=\"form_Game\"> \n");

	// Begin a paragraph with id to enable changing the text
    // Buttons to stop game and for user manual
	
	// Using images instead of <input type=\"button\" > has two advantages:
	// 1. You can determine yourself, how it looks like.
	// 2. It needs no form! a) We can write text and buttons (i.e. images) within one line
	//                      b) Using this method the complete form of the page would not be needed. 
	//                         (However I do not remove the form, as there would be a lot of changes!)
	// The disadvantage is probably that we cannot submit() an img.
	// <button> could generate a button with img to display.
    // this works, but the button looks ugly:   of.document.write ("<input type=\"button\" name=\"button_StopGame\" value=\"Beende das Memoryspiel\" onClick=\"top.stop_game();\"></input>\n");
	of.document.write ('<img src="button_stop.png"      border="2" alt="stop_game" name="button_StopGame" onClick="top.stop_game()"> ');
	of.document.write ('<img src="button_anleitung.png" border="2" alt="anleitung" name="button_OpenUserManual" onClick="top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();"><br>');

    // this works, but the button looks ugly:   of.document.write ('<input type="button" name="button_OpenUserManual" value="Anleitung & Impressum" onClick="new_wnd=top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();"></input>\n');
    // this works, but the button looks ugly:   of.document.write ('<input type="text"   name="button_NextAction" value="Nchste Aktion: Spieler 1 deckt das 1. Bild mit einem Mausklick auf." size="72" disabled></input><br>\n');

	// next action
	// I tried to write the above buttons within the paragraph, but no buttons appeared!
	// of.document.write ('<p id="p_next_action"> color="red"\n');
	// of.document.write (' Nchste Aktion</p>\n');
	
	/* This is a test how to change the text of a paragraph (or h1 ...)
	Elementknoten = of.document.getElementById("p_next_action");   // NOTE: do not use document, but of.document!!
	// Debugger shows: Elementknoten.
	// textContent = "Nchste Aktion" 
	// innerHTML = "Nchste Aktion"    (also firstChild contains this value)
	// outerHTML = "<p id=\"pn\">Nchste Aktion</p>"
	// isContentEditable = false
	
	Elementknoten.textContent = "textContent";             // This worked inspite of isContentEditable = false
	Elementknoten.innerHTML = "innerHTML";                 // This worked inspite of isContentEditable = false
	Elementknoten.outerHTML = '<p id="pn">outerHTML</p>';  // This worked inspite of isContentEditable = false
	Elementknoten.isContentEditable = true;                // This did not work. After calling this, the next 3 line did no longer work.
	Elementknoten.textContent = "textContent";
	Elementknoten.innerHTML = "innerHTML";
	Elementknoten.outerHTML = '<p id="pn">outerHTML</p>';

	//element_id_of_next_action = document.all.length;     // This gave 13 as result, but this result could not be used.
	//alert (element_id_of_next_action);
	//alert (document.all[element_id_of_next_action-1].innerText);  // does not work. "document.all" is old style that should not be used. Use document.node instead.
	*/
	

    // Roundcounter
	// Here we just draw the transparent images. Later we will print the numbers left
	// adjusted without blanks, as the length of the number never decreases.
	// vertical centering the text seems to work in HTML tables, but not in normal HTML text.
	// CSS could do it:
	
    of.document.write ('<a name="anchos"></a>\n');    // to jump directly to the round counter, as all above is not so important
	// NOTE: This anchor is only defined within the form. 
	//       document.anchors does not know this anchor and therefore window.location.hash = "#anchos" does not work.
	//       of.document.anchors knows "anchos", but jumping to this is a bit tricky (seems
	//       https://stackoverflow.com/questions/13084291/adding-anchor-point-in-form-on-submit
	//	     https://stackoverflow.com/questions/693545/is-it-possible-to-add-an-anchor-to-a-form-post-get
	//       Those solutions no longer work, as forms.submit() is depreciated.
	of.document.write ('<table border="1" cellpadding="5" >   <tr align="center" valign="middle">');  
	// bgcolor is working with td, tr and table, but for none of them the text color can be modified.
	// This is only possible using CSS or you must change it in body for the whole page.
	// I tried: * color="red"
	//          * text="red"
	// Headlines
    of.document.write ('<td> <font size="+2" color="yellow">Runde </font>\n');
	of.document.write ('</td>');
	
    for (i = 1; i <= act_players; i++)
    {
        of.document.write ('<td bgcolor=' + colors[i] + '> <font size="+2" color="yellow"> Spieler ' + i + '</font></td> \n');
    }
	of.document.write ('</tr>'); 
	
	// Table row for counters
	images_in_front_of_round_counter = of.document.images.length;
	of.document.write ('<tr><td> ');
    for (i = 0; i < digits_round_counter; i++)
	{
		// of.document.write (' <img src="' + found_picture_name + '" height="' + image_width + '" border="0" alt="round_counter_' + i + '" name="round_counter_' + i + '>\n');
		of.document.write (' <img src="' + found_picture_name + '" align="middle" border="0" alt="round_counter_'+ i + '">');
		// align="middle"    will align the text besides the image so that the text is in the middle height of the picture.
	}
	of.document.write ('</td> \n');
	images_in_front_of_pt_counter_1 = of.document.images.length;
    for (i = 1; i <= act_players; i++)
    {
		help = '<td  bgcolor=colors[' + (1+i) + ']>'
		of.document.write ('<td  bgcolor=' + colors[i] + '>');
		for (j = 0;   j < digits_points_counter;   j++)
		{
			of.document.write ('<img src="' + found_picture_name + '" alt="point_counter_'+ i + '_' + j + '">');
		}
		of.document.write ('</td> \n');
    }
	
	of.document.write ('</td></tr></table>');

	images_in_front_of_memory = of.document.images.length;
   
	// Draw dummy images
	of.document.write ("<br>\n");
    for (i = 0; i < number_of_images; i++)
    {
		 draw_new_image (i);
    }

	of.document.write ('<table border="0" cellpadding="0" >   <tr>');  
	// <p> must be defined within <span> !!! Else there is no effect.
	// We use a monospace font. Else the text of "next_action" varies in length which causes 
	// the table width of the 1st column to jump. Then the images in the 2nd column jump too!
	// This would not be nice.
    of.document.write ('<td><span style="font-family:monospace; font-size:80%"><p id="next_act">Nchste Aktion: Spieler 1 deckt das 1. Bild mit einem Mausklick auf.</p></span></td>\n');

	// When we focus to "focus_point_href" the Browser displays the referred link address in the left lower corner
	// and hides the Stop button there. -> Print the button to a right adjusted paragraph.
	of.document.write ('<td>&nbsp &nbsp &nbsp &nbsp &nbsp ');
	of.document.write (' <img src="button_stop.png"      border="2" alt="stop_game2" name="button_StopGame2"   onClick="top.stop_game()"> ');
	of.document.write (' <img src="button_anleitung.png" border="2" alt="anleitung2" name="button_OpenUserManual2" onClick="top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();">');
	
	
	// ------------ Add an invisible element to enable scrolling to this position. 
	// First I tried <input type="hidden">, but with this focus did not work. (Yes, it makes no sense to jump to a hidden thing.)
	// Focussing onto input elements of type text or button works, but I found no way to make them invisible.
    // works, but looks ugly: of.document.write ("<input type=\"input\" name=\"button_StopGame3\"   value=\"Beende das Memoryspiel\" onClick=\"top.stop_game();\">\n");

	// <button> is another methode to define a button. You can place images and text within this button, but it always remains a gray border.
	// I tried to change the gray bg-color by bgcolor="red", but this did not work.
	// This <button> works, but ugly layout: of.document.write('<div>    <button name="Klickmich" type="button"      value="berraschung" onclick="alert(\"berraschung!\");"> <p> <img src="q.png" alt="SELFHTML Logo"><br>        <b>Was passiert wohl?</b>      </p>    </button>  </div>');
    // Only small gray border: of.document.write('<div>    <button name="Klickmich" type="button"      value="berraschung" onclick="alert(\"berraschung!\");"> <img src="q.png" alt="SELFHTML Logo">   </button>  </div>');
	// works, but with gray frame: of.document.write('<button name="Klickmich" type="button"   value="berraschung" onclick="alert(\"berraschung!\");"> <img src="q.png" alt="SELFHTML Logo">   </button>');
    //of.document.write ("<input type=\"button\" name=\"button_StopGame2\"   value=\"Beende das Memoryspiel\" onClick=\"top.stop_game();\">\n");
    //of.document.write ('<input type="button" name="button_OpenUserManual2" value="Anleitung & Impressum" onClick="new_wnd=top.open(\'anleitung_frameset.htm\',\'Spielanleitung\');new_wnd.focus();">\n');
    //of.document.write ('<input type="text"   name="button_TimeUsage"       value="Verbrauchte Zeit seit dem Start des Spiels:" size="72" disabled></input><br>\n');
	
	// This is an  trick, but it works: An element <a href> can get the focus, too!
	// Make a small font (font color does not work here, probably because it is a link) and very short output
	// Too make it completely invisible, change the links colors (see memory.htm)
	of.document.write ('<font size="1" color="red"><a id="focus_point_href" href="./memory.htm"> </a></font>\n')
	// focus() for a simple anchor did not work: of.document.write ('<a name="focus_point_anchor">ff</a>\n')
	of.document.write ('</td></tr></table>'); 

	// In the old memory code this line was before (!) the memory images.
	of.document.write ("</form>\n");

	// Add some empty lines to enable scrolling up the pictures
	of.document.write ("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");


}  // end: function draw_html_for_game()

//----------------------------   draw_new_image ()   ---------------------------
function draw_new_image (i)
{
         // ! the name (NOT the alt_text) is used to extract the picture index. Do not change the name syntax!
		 // In the math memory we apply the same name to all sub-images. I hope, this works well, as it
		 // makes it easy to detect, which main-image was clicked.
		 var char1 = "";
		 var img_name = "";
		 var pos = 0;
         var alt_text = "Memoryteil_" + (i+1);
         if (show_picture_name == true)
         {
             alt_text += ":_";     // with blank here, IE6.0 cuts output at blank
             alt_text += mixed_images[indexes_array[i]];
         }
		 // alert (alt_text + "  " + indexes_array.length + "  " + mixed_images.length);
		 of.document.write ('<nobr>');    // forbid line break inbetween a main-image
		 for (pos = 0;   pos <  mixed_images[indexes_array[i]].length;   pos++)
		 {
			of.document.write ('<img src="' + get_img_name (draw_open_images? 2 : 0, pos, i) + '" height="' + image_width + '" border="0" alt="' + alt_text + '" name="image' + i + '" onClick="top.show_hidden_image(this)">');
		 }
		 of.document.write ('</nobr> '); // If we do not print the blank behind </nobr>, FF prints only one line. With blank the line break works well.
	
} // end: draw_new_image()

//-------------------------------   get_img_name   ---------------------------------------
// img_type     : 0: replace by hidden images
//                1: replace by found  images
//                2: replace by the open images, which are encoded in code_string
// position     : 0 ... number of sub-images -1: This is the index of the sub-image within one main image
// main_index   : This is the index of the main image (unused, if img_is_hidden == false)

function get_img_name (img_type, position, main_index)
{
	var image_name;
	
	if (img_type == 0)
	{
		image_name = 'hidden_' + position + '.jpg';
	}
	else if (img_type == 1)
	{
		image_name = found_picture_name;
	}
	else
	{
		var char1 = mixed_images[indexes_array[main_index]].substr (position, 1);
		if (char1 == " ") char1 = "b";
		if (char1 == "*") char1 = "m";
		if (char1 == "+") char1 = "a";
		if (char1 == "-") char1 = "s";
		if (char1 == "/") char1 = "d";
		image_name = char1 + '.png';
	}
	return image_name;
}


//-----------------------------   replace_sub_images   -------------------------
// clicked_index     : This is the index of the clicked image in the image array of the HTML page
// clicked_main_index: This is the index of the main image, of which the sub-images are to be replaced
// img_type          : 0: replace by hidden images
//                     1: replace by found  images
//                     2: replace by the open images, which are encoded in code_string
function replace_sub_images (clicked_index, clicked_main_index, img_type)
{
	var pos;
	
	for (pos = 0;   pos < num_subimages;   pos++)
	{
		of.document.images[images_in_front_of_memory + (clicked_index * num_subimages) + pos].src = get_img_name (img_type, pos, clicked_index);
	}
	
	if (img_type == 1)
	{
		timeouts_finished++;
	}

}

//-----------------------   show_hidden_image ()   -----------------------------
// parameter: this-object of the clicked image. We use it to determine the
// index of the image that was clicked by comparing clicked_image with all
// other images actually displayed.
function show_hidden_image (clicked_image)
{

	if (timeouts_started > timeouts_finished)
	{
		// Audio for illegal mouse action
		if (audio_illegal_click) audio_illegal.play();
		return;
	}
	
    if (opened_images_in_turn < num_matching_images)
    {
        // This is a real click (else: just click to jump to next player

        // replace the hidden images by the Memory images
		var pos;                    // index of sub-image within main-image
        var clicked_index = -1;     // index of image that was clicked
		var command = "";           // A command string for setTimeout
        clicked_index = parseInt(clicked_image.name.substr(5,10));
		if (clicked_image.src.search("hidden_") != -1)        {
            // only in this case we have to do anything. Else the image is not
            // hidden and the click is ignored
            displayed_picture_index = indexes_array[clicked_index];
			replace_sub_images (clicked_index, displayed_picture_index, 2);
			// for (pos = 0;   pos < mixed_images[displayed_picture_index].length;   pos++)
			// {
			// 	of.document.images[(clicked_index * num_subimages) + pos].src = get_img_name (false, pos, displayed_picture_index);
			// }

            // store clicked index
            last_clicked_indexes[opened_images_in_turn] = clicked_index;
            opened_images_in_turn++;

            if (opened_images_in_turn == num_matching_images)
            {
                // The player has opened the maximum number of images. Now check
                // whether they match.
                var matching = true;
                for (i = 0;   i < (num_matching_images - 1);   i++)
                {
                    if (Math.floor(indexes_array[last_clicked_indexes[i]  ] / num_matching_images)
                    !=  Math.floor(indexes_array[last_clicked_indexes[i+1]] / num_matching_images))
                    {
                        matching = false;
						if (audio_mismatch) audio_mismatching.play();
                    }
                }

                if (matching == true)
                {
					// I would like to wait here for some seconds. But the internet tells, that
					// there is no sleep function in JS. 
					// windows.setTimeout does not wait. It starts a thread that calls the 
					// function after 2 seconds, but the program immediately continues at the 
					// statement below.
					// window.setTimeout ('alert ("Pause beendet")', 2000);  
					if (audio_match) audio_matching.play();
					
					// The next is active waiting, but only for 1 second
					// Unfortunately, the images been opened above (this works, as the debugger shows
					// the images immediately), but here (during the waiting) the hidden images are
					// shown! May be, the program waits with the window update until this 
					// function is ready. Even output_actual_game_standings(); does not help.
					// => sleep only 1msec
					// We could start replace_sub_images () 
					// var now = new Date();
					// var ms = Date.UTC (now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), now.getSeconds());
					// do
					// {
					// 	now = new Date();
					// } while ((ms + 1) > Date.UTC (now.getFullYear(), now.getMonth(), now.getDate(), now.getHours(), now.getMinutes(), now.getSeconds()))
					
					
                    // the actual player gets a point, remains on turn and the
                    // images are replaced by the "found picture".
                    points_of_player[act_player - 1]++;
                    for (i = 0;   i < num_matching_images;   i++)
                    {
						//window.setTimeout ('alert("i="+i)', 3000); // Im Prinzip arbeitet diese Funktion, aber das i bekommt nicht den Wert zum Zeitpunkt,
						                                             // wenn diese Zeile abgearbeitet wird (kurz nach dem Klick), sondern von dem Zeitpunkt,
																	 // wenn die vergerte Funktion ausgefhrt wird. Und deshalb funktioniert die nchste 
																	 // Zeile nicht!
																	 
						// command = "alert(i=" + i + ")";           // Mit dieser Methode erzwinge ich die sofortige Auflsung von i. Obwohl "command"
						// window.setTimeout (command, 3000);        // eine lokale Variable ist, bleibt der Befehl auch nach Beedigung der Funktion 
																	 // erhalten. Ja sogar beide Befehle mit Verschiedener Ausgabe werden dann nach-
																	 // einander ausgefhrt. 
							
						// Mit der Erkenntnis der obigen Versuche klappt dann auch das versptete Ersetzen
						// der geffneten Karten durch die Bilder fr gefundene Karten. Zuerst hatte ich
						// die rechte Seite der command-Zuweisung direkt im setTimeout-Befehl, aber das hatte
						// nicht geklappt.
						// Probleme knnte diese Methode allerdings machen, wenn man zu schnell weiterklickt,
						// weshalb ich die Wartezeit relativ kurz mache.
						// Nach dem letzen Paar wird die Methode nicht mehr ausgefhrt, weil die Erfolgs-
						// Meldungsbox kommt und danach die Seite sofort verlassen wird. Ich hoffe, da das
						// keine Probleme macht.
						// Ob diese Methode in allen Browsern so funktioniert, mu auch getestet werden.
						command = "replace_sub_images (" + last_clicked_indexes[i] + ", -1 , 1)";
						window.setTimeout (command, (match_timeout * 1000) + (i*200));		
						timeouts_started++;
                        // old: of.document.images[last_clicked_indexes[i]].src = found_picture_name;
                        last_clicked_indexes[i] = -1;
                    }
                    opened_images_in_turn = 0;

                    // test whether all pieces are found
                    var found_images = 0;
                    for (i = 0;   i < act_players;   i++)
                    {
                        found_images += points_of_player[i];
                    }
                    found_images *= num_matching_images;
                    if (found_images == number_of_images)
                    {
                        output_actual_game_standings();   // show standings before msg box
 						if (audio_match) audio_matching.play();
                        if (act_players == 1)
                        {
							// https://bugzilla.mozilla.org/show_bug.cgi?id=567738 tells:
							// On Mozilla Firefox 3.6.3, a modal-dialog box generated by alert() 
							// before the page has finished loading in Javascript will not allow 
							// the user to move the dialog box.
							// BA: The same is true for confirm() and prompt(). For IE it is no problem.
							// prompt("Please enter your name", "Harry Potter");
                            alert ("       !!! Herzlichen Glckwunsch !!!\n Du hast alles richtig gefunden. \n Drcke OK um ein neues Spiel zu starten.");
                        }
                        else
                        {
                            alert ("       !!! Herzlichen Glckwunsch !!!\n Ihr habt alles richtig gefunden. \n Drckt OK um ein neues Spiel zu starten.");
                        }
                        ask_for_game_settings();
                        return;
                    }

                }
                else
                {
                    // images not matching: just wait for next click on image before
                    // hiding the opened images and jumping to next player
                }
            }
        }
    }   // end: if (opened_images_in_turn < num_matching_images)
    else
    {
        // This was a click to jump to next player
        // images not matching: hide the opened images and jump to next player
        for (i = 0;   i < num_matching_images;   i++)
        {
			replace_sub_images (last_clicked_indexes[i], -1 /*unused*/, 0);
            last_clicked_indexes[i] = -1;
        }

        // jump to next player
        opened_images_in_turn = 0;
        if (act_player == act_players)
        {
            act_player = 1;
            round_counter++;
        }
        else
        {
            act_player++;
        }
    }

    output_actual_game_standings();

    return;

}

//-----------------------   mix_images ()   ------------------------------------
// Use random generator to mix the order of the images
function mix_images()
{
    random_array = new Array(number_of_images);
    index_array  = new Array(number_of_images);
    for (i=0; i < number_of_images; i++)
    {
        random_array[i] = Math.random();
        index_array[i]  = i;
        // alert (random_array[i] + ", " + index_array[i]);
    }

    mix_array (random_array, index_array);

    // Draw mixed images  (only for testing)
    for (i=0; i < number_of_images; i++)
    {
           //alert (random_array[i] + ", " + index_array[i]);
    //     document.images[i].src = original_images[index_array[i]];
    }
}   // end: function mix_images()


//------------------------   generate_math_problems   -----------------------------
// Generates the desired number of math problems and writes it as pairs 
// (problem-string, result-string) to predefined_image_names. 
function generate_math_problems()
{
	//alert ("generate_math_problems for so many images: " + used_images);
	var i;
	var j;
	var o1;
	var o2;
	var result;
	var result_string;
	var result_doublet;
	
	predefined_image_names.length = 0;    // empty the old problems
	for (i=0; i < used_images * 3; i+=2)    
	// For the case that the program generates doublet result strings we must
	// eliminate those and have to perform more calculations than used_images.
	// To avoid an endless loop, we limit the calculations to 3*used_images
	// and break the loop, if the desired number is reached below.
	{
		result_doublet = false;   // Whenever we do not use the numbers, this becomes true.
		o1 = min_num_1 + Math.random(5) * (max_num_1 - min_num_1 + 1);
		o1 = parseInt (o1);
		o2 = min_num_2 + Math.random(3) * (max_num_2 - min_num_2 + 1);
		o2 = parseInt (o2);
		
		if (selected_operator[0] == "+")
		{
			result = o1 + o2;
			result_string = make_string_from_number (result, num_subimages);
		}
		else if (selected_operator[0] == "-")
		{
			if (selected_operator[1] == " "   &&   o1 < o2)   // without negative results
			{
				result = o1;
				o1 = o2;
				o2 = result;
			}
			result = o1 - o2;
			result_string = make_string_from_number (result, num_subimages);
		}
		else if (selected_operator[0] == "*")
		{
			result = o1 * o2;
			result_string = make_string_from_number (result, num_subimages);
		}
		else if (selected_operator[0] == "/")
		{
			if (o2 != 0) 
			{
				result = o1 / o2;
				result = parseInt (result);
				if (selected_operator[1] == " ")   // only divisions without rest are allowed
				{
					o1 = result * o2;
					result_string = make_string_from_number (result, num_subimages);
				}
				else
				{
					result_string = make_string_from_number (result, (num_subimages-1)/2) + "R" 
								  + make_string_from_number (o1 - (result * o2), (num_subimages-1)/2);
				}
			}
			else
			{
				result_doublet = true;
			}
		}
		
		// If this result value already exists, ignore it. Else add it to the list.
		for (j = 0;   j < predefined_image_names.length;   j+=2)
		{
			if (result_string == predefined_image_names[j+1])
			{
				result_doublet = true;
				break;
			}
		}
		
		if (!result_doublet)
		{
			j = predefined_image_names.length;
			predefined_image_names[j  ] = make_string_from_number (o1, 2) + selected_operator[0] + make_string_from_number (o2, 2);
			predefined_image_names[j+1] = result_string;
			if (predefined_image_names.length >= used_images)
			{
				break;
			}
		}
	}
	
	number_of_predefined_images = predefined_image_names.length;   // needed in case of too many doublets
	used_images = number_of_predefined_images;
	number_of_images = number_of_predefined_images;
	
	// alert ("generated images: " + used_images);
}   // end: generate_math_problems()