//-----------------------   mix_array ()   ------------------------------------
// This function sorts the unsorted data_array and remembers the sorting
// order in index_array which should be sorted when calling the function.
// Example:
//   in: data_array is an random number array and index_array contains 1, 2, ....
//  out: data_array is sorted, index_array[i] contains the index of the (original)
//       element in data_array that was moved to position i (according to the
//       sorting order).
// Example:
//   in: data_array=3,0,2,5,1,4      index_array=0,1,2,3,4,5
//  out: data_array=0,1,2,3,4,5      index_array=1,4,2,0,5,3
//
function mix_array (data_array, index_array)
{
    // Define an object which contains one data and one index element
    // Then we make an array of these object. use the sort function
    // for the data element only. In this way the index elements are
    // ordered new too and at the end we only have to write back the
    // new order into the original arrays.

    // Define combined object consisting of data and index:
    function combi(data, index)
    {
        this.data  = data;
        this.index = index;
    }

    // Define function to sort the combi objects
    function combi_sort (a, b)
    {
        // for numerical data-values we could return just the difference "a-b", but
        // to be able to process other objects too, we do the following:
        var result = -1;
        if (a.data > b.data)
        {
            result = 1;
        }
        else if (a.data == b.data)
        {
            result = 1;
        }

        return result;
    }

    var array_length = data_array.length;
    var sort_array = new Array (array_length);
    var i;           // loop counter

    // Write input array elements into combi array for sorting
    for (i = 0;   i < array_length;   i++)
    {
          sort_array[i] = new combi(data_array[i], index_array[i]);
    }


    // Sort
    sort_array.sort(combi_sort);


    // Write sorted order back to original array
    for (i = 0;   i < array_length;   i++)
    {
          data_array[i]  = sort_array[i].data;
          index_array[i] = sort_array[i].index;
    }

}  // end: function mix_array()


//----------------------------------   make_string_from_number()   --------------------------------
// Make a string from the input number. If the result would have less characters than min_num_of_characters,
// the function fills the front with blanks.
function make_string_from_number (number, min_num_of_characters)
{
	// alert ("ms: " + number + " " + min_num_of_characters);
	var result = number.toString (10);
	// alert (result + "  " + result.length);
	while (result.length < min_num_of_characters)
	{
		result = " " + result;
		// alert ("R" + result);
	}
	return result;
}